//
//  MCDisplayStateProtocol.h
//  MCApplication
//
//  Created by Ali Lalani on 7/5/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>


@protocol MCDisplayState <NSObject>
// This sets the display state, and delegate, and then cascades down to everything it cares about
// Creating mutable dictionary configurations for each if necessary and telling them to read/write when necessary
- (void)setDisplayState:(NSMutableDictionary *)aConfig withDisplayStateDelegate:(id)aDeleg;

// Just an accessor, implementers should keep an ivar of the display state dictionary as it will be the same one kept by its parent
// and so on up the chain
- (NSMutableDictionary *)displayState;

// Again, an accessor for setting the display state dictionary from the workspace or wherever
- (void)setDisplayState:(NSMutableDictionary *)aConfig;

// Accessors for the delegate
- (void)setDisplayStateDelegate:(id)aDeleg;
- (id)displayStateDelegate;

// If you set a display state and want the view to reflect those settings, you call this
- (void)readFromDisplayState;

// If you set a display state and you want the state to be changed to reflect the current settings of the view, you call this
- (void)writeToDisplayState;

// This should tell the display state delegate that something changed
- (void)notifyDisplayStateChange;
@end

@interface NSObject (MCDisplayStateDelegate)
- (void)objectDisplayStateDidChange:(id <MCDisplayState>)anObj;
@end
